/*******************************************************
Filename		:  	DW_bio_result_criteria_project.sql
Release 		:  	STORET c2.0
SIR			:  	1502
Description		:  	Creates a centralized form page that allows the user to query BIO results based on  
				a selected Project and other common parameters.
Author		:  	Joseph Wilson/Christine Tsang
Date			: 	July 24, 2003 -- created based on the DW_result_criteria_project page. -C Tsang
                        08/06/2003 -- SIR 1532 - Added intent and community sampled selections. -C Tsang
                        08/08/2003 -- SIR 1504 - Pass result_type value to DW_char_select. -CT
                        08/15/2003 -- Replaced the word 'BETA' with 'Biological'. -CT
Comments		:  	Calls a pop-up window for Project selection.
**********************************************************/

SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_bio_ResultCriteria_PROJECT AS

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Biological Results by Project';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,
 'adjust_width_n(document.forms[1].D_ORG_LIST,"~","15~60","None","N");document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);adjust_width_n(document.forms[1].D_INTENT_LIST,"~","30~","None","Y");adjust_width_n(document.forms[1].D_COMMUNITY_LIST,"~","30~","None","Y")');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Organization/Project selection
DW_project_select;

-- Date range selection 
DW_date_select(10);

-- Intent & Community Sampled selections
DW_intent_community_select(35);

-- Characteristics selection
DW_char_select(37,'BIOLOGICAL');

htp.print('
<input type="hidden" name="RESULT_TYPE" value="BIOLOGICAL">
<br>
<center>
<input type="button" value="Continue" tabindex=44 onclick="javascript: submitCriteria2();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=45 onclick="javascript: deleteAllFromCharList(); document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(23);

END;
/
SHOW ERRORS;